;/*************************************************************************
; Program		:Expand 8 bit I/O
; Description	:Expand 8 bit I/O with a I2C device,PCF8574A. 
;				:please connect sw to port P8..P1 of PCF8574A ,connect 
;				:serial port(RS232), then you can see result on monitor.
; CPU Control	:ATmega163
; File name		:P8574ain.asm
; Assembler		:AVR Studio 4.05
; 
;**************************************************************************

.include "m163def.inc"

			.org   	$000 
    		rjmp  reset			;Reset Handle
;/************************
; Define Register
;/************************
.def		counter1  	= r16
.def		counter2	= r17
.def		counter3	= r18
.def		temp		= r19
.def		data		= r21
;/***********************
; Define I/O Port,Pin
;/***********************
.equ		SCL		= 0
.equ		SDA		= 1
;.equ		I2CTO_ADRW	= 0x40		;address write of PCF8574
;.equ		I2CIO_ADRR	= 0x41		;address read of PCF8574
.equ		I2CIO_ADRW	= 0x70		;address write of PCF8574A
.equ		I2CIO_ADRR	= 0x71		;address read of PCF8574A
;/*******************
; Main Program
;/*******************
reset:      ldi	temp,low(RAMEND)
            out	SPL,temp          	;init Stack Pointer     
            ldi	temp,high(RAMEND)
            out	SPH,temp        	
			sbi	UCR,TXEN
			ldi	temp,51				;baudrate = 9600 bps
			out	UBRR,temp
			ldi	ZH,high(2*RS232TB)
			ldi	ZL,low(2*RS232TB)
			rcall	Intro
PCF8574A:	ser	temp
			out	DDRC,temp
			out	PORTC,temp

;/***************
; scan port
;/***************
Loop_Input:	ldi	counter1,1
			ldi	counter3,0xFE
			rcall	PCF8574A_rd
Compare_count:	
			cp	data,counter3
			breq	Show_value
			sec	
			rol	counter3
			inc	counter1
			cpi	counter1,9
			brne	Compare_count
			rjmp	Loop_Input

Show_value:	subi	counter1,-$30
			mov	data,counter1
			rcall	TX_Byte
			rcall	delay200ms
			rjmp	Loop_Input		

;/********************
; Write 1 byte 
;/********************
PCF8574A_wr:	
			rcall	I2C_Start
			ldi	data,I2CIO_ADRW
			rcall	out
			mov	data,temp
			rcall	out		
			ret

;/********************
; Read 1 byte
;/********************
PCF8574A_rd:	
			rcall	I2C_Start
			ldi	data,I2CIO_ADRR
			rcall	out
			rcall	I2C_delay
			rcall	in
			rcall	I2C_Stop
			ret

;/*********************
; I2C start statement 
;/*********************
I2C_Start:	sbi	PORTC,SDA
			sbi	PORTC,SCL
			rcall	I2C_delay
			cbi	PORTC,SDA
			rcall	I2C_delay
			cbi	PORTC,SCL
			ret

;/********************
; I2C stop statement
;/********************
I2C_Stop:	cbi	PORTC,SDA
			rcall	I2C_delay
			sbi	PORTC,SCL
			rcall	I2C_delay
			sbi	PORTC,SDA
			ret

;/*******************************
; write 8 bit data to SDA line
;/*******************************
out:		push	data
			push	counter1
			ldi	counter1,8			;8 bit 
out1:		sbi	PORTC,SDA		 
			rol	data
			brcs	out2			;if c flag=1 set SDA line else clear SDA line
			cbi	PORTC,SDA
out2:		nop
			sbi	PORTC,SCL
			rcall	I2C_delay
			cbi	PORTC,SCL
			rcall	I2C_delay
			dec	counter1
			brne	out1
			sbi	PORTC,SDA
			nop
			sbi	PORTC,SCL
			rcall	I2C_delay
			sbic	PINC,SDA		;if SDA line=1,begin write old data again
			rjmp	out3
			cbi	PORTC,SCL
			pop	counter1
			pop	data
			ret
out3:		pop	counter1
			pop	data
			rjmp	out

;/********************************
; receive 8 bit from SDA line
;/******************************** 
in:			push	counter1
			ldi	counter1,8			;8 bit data
			sbi	PORTC,SDA			;set SDA line for receiving new data
in1:		nop
			sbi	PORTC,SCL
			sec
			sbis	PINC,SDA		;set c flag when SDA line = 1
			clc
			rol	data				;rotate left
			cbi	PORTC,SCL
			rcall	I2C_delay
			dec	counter1
			brne	in1			
			sbi	PORTC,SDA			;send Acknowledge bit
			nop
			sbi	PORTC,SCL
			rcall	I2C_delay
			cbi	PORTC,SCL
			pop	counter1
			ret

;/*************
; Send text
;/*************
Intro:		lpm
			tst	r0
			breq	end_sub
TX232:		sbis	USR,UDRE
			rjmp	TX232
			out	UDR,r0
			adiw	ZL,1
			rjmp	Intro
end_sub:	ret		

;/******************
; Send a byte
;/******************
TX_Byte:	sbis	USR,UDRE
			rjmp	TX_Byte
			out	UDR,data
			ret

;/*****************
; delay time
;/*****************
I2C_delay:	push	counter1
			ldi    	counter1,5
I2C_delay_1: 	
			dec    	counter1
            brne   	I2C_delay_1
			pop	counter1
			ret          

delay1ms:	push	counter1
			push	counter2
			ldi	counter1,16
delay1ms_1: ldi    	counter2,250
delay1ms_2: nop
			dec    	counter2
            brne   	delay1ms_2
            dec    	counter1
            brne   	delay1ms_1
            pop	counter2
			pop	counter1
			ret          

delay200ms:	push	counter3
			ldi	counter3,200
delay200ms_1:	
			rcall	delay1ms
			dec	counter3
			brne	delay200ms_1
			pop	counter3
			ret

;/***************
; text segment
;/***************
RS232TB:	.db	"Test PCF8574/A. ",0x0a,0x0d
			.db	"this program will use PCF8574A is 8 bits input port. ",0x0a,0x0d,0
		

           	 